<?php

declare(strict_types=1);

namespace App\Controllers;

class DashboardController
{
    public static function index(): void
    {
        if (request_method() === 'POST') {
            $name = trim((string)request_input('name', ''));
            if ($name !== '') {
                $existing = fetch_one('SELECT id FROM portfolio WHERE name = :name', ['name' => $name]);
                if (!$existing) {
                    execute('INSERT INTO portfolio (name, created_at) VALUES (:name, NOW())', ['name' => $name]);
                    flash('Portfolio created.', 'success');
                }
            }
            redirect('/');
        }

        $portfolios = fetch_all('SELECT * FROM portfolio ORDER BY id');
        $selectedId = request_input('portfolio_id');
        $selectedId = $selectedId !== null ? (int)$selectedId : null;
        if (!$selectedId && !empty($portfolios)) {
            $selectedId = (int)$portfolios[0]['id'];
        }

        $holdings = [];
        if ($selectedId) {
            $holdings = fetch_all(
                'SELECT h.*, s.symbol, s.sector FROM holding h JOIN stock s ON s.id = h.stock_id WHERE h.portfolio_id = :pid',
                ['pid' => $selectedId]
            );
        }

        $sectorData = [];
        foreach ($holdings as $holding) {
            $sector = $holding['sector'] ?: 'Unknown';
            $total = (float)$holding['quantity'] * (float)$holding['buy_price'];
            $sectorData[$sector] = ($sectorData[$sector] ?? 0) + $total;
        }

        $stocks = fetch_all('SELECT * FROM stock ORDER BY symbol');

        render('dashboard', [
            'portfolios' => $portfolios,
            'selected_id' => $selectedId,
            'holdings' => $holdings,
            'sector_data' => $sectorData,
            'stocks' => $stocks,
        ]);
    }
}
