<?php
$title = 'JS Global Calls Dashboard';
?>
<h3>JS Global Technical Calls (<?= e($date_filter) ?>)</h3>

<form method="GET" action="/js-calls" class="row g-3 mb-4">
  <div class="col-md-3">
    <label for="date" class="form-label">Filter by Date</label>
    <input type="date" id="date" name="date" class="form-control" value="<?= e($date_filter) ?>">
  </div>
  <div class="col-md-2 d-flex align-items-end">
    <button type="submit" class="btn btn-primary w-100">Filter</button>
  </div>
</form>
<div class="row mb-4">
  <div class="col-md-12">
    <div class="card-group gap-3">
      <a href="/js-calls/upload-daily" class="btn btn-outline-primary">Upload Daily Calls</a>
      <a href="/js-calls/upload-pivot" class="btn btn-outline-primary">Upload Pivot Calls</a>
      <a href="/js-calls/daily-calls" class="btn btn-outline-secondary">View/Edit Daily Calls</a>
      <a href="/js-calls/pivot-calls" class="btn btn-outline-secondary">View/Edit Pivot Calls</a>
    </div>
  </div>
</div>

<div class="row">
  <div class="col-md-6">
    <h5>Daily Calls</h5>
    <table class="table table-bordered table-sm">
      <thead class="table-light">
        <tr><th>Symbol</th><th>Strategy</th><th>Close</th><th>S1</th><th>Pivot</th><th>R1</th><th>RSI 14</th></tr>
      </thead>
      <tbody>
        <?php foreach ($daily_calls as $c): ?>
          <tr>
            <td><?= e($c['symbol']) ?></td>
            <td><?= e($c['strategy']) ?></td>
            <td><?= e($c['close_price']) ?></td>
            <td><?= e($c['s1']) ?></td>
            <td><?= e($c['pivot']) ?></td>
            <td><?= e($c['r1']) ?></td>
            <td><?= e($c['rsi_14']) ?></td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>

  <div class="col-md-6">
    <h5>Pivot Calls</h5>
    <table class="table table-bordered table-sm">
      <thead class="table-light">
        <tr>
          <th>Symbol</th><th>Close</th><th>Vol</th><th>RSI</th><th>RSI Signal</th><th>MACD</th><th>Pivot</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($pivot_calls as $p): ?>
          <tr>
            <td><?= e($p['symbol']) ?></td>
            <td><?= e($p['close_price']) ?></td>
            <td><?= e($p['volume']) ?></td>
            <td><?= e($p['rsi_14']) ?></td>
            <td><?= e($p['rsi_signal']) ?></td>
            <td><?= e($p['macd_signal']) ?></td>
            <td><?= e($p['pivot']) ?></td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>
