<?php
$title = 'Daily Calls';
?>
<h3>JS Global Daily Calls</h3>
<table id="dailyCallsTable" class="table table-striped table-bordered">
  <thead>
    <tr>
      <th>Date</th><th>Symbol</th><th>Strategy</th><th>Close</th><th>S1</th><th>Pivot</th><th>R1</th><th>RSI 14</th><th>Actions</th>
    </tr>
  </thead>
  <tbody>
    <?php foreach ($calls as $call): ?>
      <tr>
        <td><?= e($call['uploaded_at']) ?></td>
        <td><?= e($call['symbol']) ?></td>
        <td><?= e($call['strategy']) ?></td>
        <td><?= e($call['close_price']) ?></td>
        <td><?= e($call['s1']) ?></td>
        <td><?= e($call['pivot']) ?></td>
        <td><?= e($call['r1']) ?></td>
        <td><?= e($call['rsi_14']) ?></td>
        <td>
          <a href="/js-calls/edit-daily/<?= e($call['id']) ?>" class="btn btn-sm btn-warning">Edit</a>
          <a href="/js-calls/delete-daily/<?= e($call['id']) ?>" class="btn btn-sm btn-danger" onclick="return confirm('Delete this call?')">Delete</a>
        </td>
      </tr>
    <?php endforeach; ?>
  </tbody>
</table>
