<?php
$title = 'Pivot Calls';
?>
<h3>JS Global Pivot Calls</h3>
<table id="pivotCallsTable" class="table table-striped table-bordered">
  <thead>
    <tr>
      <th>Date</th><th>Symbol</th><th>Close</th><th>Volume</th><th>RSI 14</th><th>RSI Signal</th><th>MACD</th><th>S3</th><th>S2</th><th>S1</th><th>Pivot</th><th>R1</th><th>R2</th><th>R3</th><th>Actions</th>
    </tr>
  </thead>
  <tbody>
    <?php foreach ($calls as $call): ?>
      <tr>
        <td><?= e($call['uploaded_at']) ?></td>
        <td><?= e($call['symbol']) ?></td>
        <td><?= e($call['close_price']) ?></td>
        <td><?= e($call['volume']) ?></td>
        <td><?= e($call['rsi_14']) ?></td>
        <td><?= e($call['rsi_signal']) ?></td>
        <td><?= e($call['macd_signal']) ?></td>
        <td><?= e($call['s3']) ?></td>
        <td><?= e($call['s2']) ?></td>
        <td><?= e($call['s1']) ?></td>
        <td><?= e($call['pivot']) ?></td>
        <td><?= e($call['r1']) ?></td>
        <td><?= e($call['r2']) ?></td>
        <td><?= e($call['r3']) ?></td>
        <td>
          <a href="/js-calls/edit-pivot/<?= e($call['id']) ?>" class="btn btn-sm btn-warning">Edit</a>
          <a href="/js-calls/delete-pivot/<?= e($call['id']) ?>" class="btn btn-sm btn-danger" onclick="return confirm('Delete this call?')">Delete</a>
        </td>
      </tr>
    <?php endforeach; ?>
  </tbody>
</table>
