<?php
$title = 'Dashboard';
?>
<h3>Portfolio Overview</h3>

<form method="POST" action="/">
  <div class="row mb-3">
    <div class="col-md-4">
      <input type="text" name="name" class="form-control" placeholder="Add new portfolio" required>
    </div>
    <div class="col-md-2">
      <button type="submit" class="btn btn-primary">Create</button>
    </div>
  </div>
</form>

<form method="GET" action="/">
  <div class="row mb-4">
    <div class="col-md-6">
      <select name="portfolio_id" class="form-select" onchange="this.form.submit()">
        <?php foreach ($portfolios as $p): ?>
          <option value="<?= e($p['id']) ?>" <?= ($p['id'] == $selected_id) ? 'selected' : '' ?>><?= e($p['name']) ?></option>
        <?php endforeach; ?>
      </select>
    </div>
  </div>
</form>

<h4>Add Holding to Selected Portfolio</h4>
<form method="POST" action="/portfolio/add" class="row g-3 mb-4">
  <input type="hidden" name="portfolio_id" value="<?= e($selected_id) ?>">
  <div class="col-md-4">
    <select name="symbol" class="form-select" required>
      <option value="" disabled selected>Select Symbol</option>
      <?php foreach ($stocks as $s): ?>
        <option value="<?= e($s['symbol']) ?>"><?= e($s['symbol']) ?> - <?= e($s['sector']) ?></option>
      <?php endforeach; ?>
    </select>
  </div>
  <div class="col-md-2">
    <input type="number" name="qty" class="form-control" placeholder="Quantity" required>
  </div>
  <div class="col-md-2">
    <input type="number" step="0.01" name="price" class="form-control" placeholder="Buy Price" required>
  </div>
  <div class="col-md-2">
    <button type="submit" class="btn btn-success w-100">Add Holding</button>
  </div>
</form>

<canvas id="sectorChart" height="100"></canvas>

<table class="table table-striped mt-4">
  <thead>
    <tr>
      <th>Symbol</th>
      <th>Sector</th>
      <th>Qty</th>
      <th>Buy Price</th>
      <th>Total Cost</th>
    </tr>
  </thead>
  <tbody>
    <?php foreach ($holdings as $h): ?>
      <tr>
        <td><?= e($h['symbol']) ?></td>
        <td><?= e($h['sector'] ?: '--') ?></td>
        <td><?= e($h['quantity']) ?></td>
        <td><?= number_format((float)$h['buy_price'], 2) ?></td>
        <td><?= number_format((float)$h['quantity'] * (float)$h['buy_price'], 2) ?></td>
      </tr>
    <?php endforeach; ?>
  </tbody>
</table>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
  const ctx = document.getElementById('sectorChart').getContext('2d');
  const sectorData = <?= json_encode($sector_data, JSON_UNESCAPED_SLASHES) ?>;
  new Chart(ctx, {
    type: 'pie',
    data: {
      labels: Object.keys(sectorData),
      datasets: [{
        label: 'Sector Allocation',
        data: Object.values(sectorData),
        backgroundColor: ['#007bff', '#dc3545', '#28a745', '#ffc107', '#6f42c1', '#20c997', '#fd7e14']
      }]
    }
  });
</script>
