<?php
$title = 'Portfolio Dashboard';

$totAmt = 0.0;
$totVal = 0.0;
$totPl = 0.0;
$totTodayPl = 0.0;
$totDiv = 0.0;

$gAmt = 0.0;
$gVal = 0.0;
$gPl = 0.0;
$gTodayPl = 0.0;
$gDiv = 0.0;

$lAmt = 0.0;
$lVal = 0.0;
$lPl = 0.0;
$lTodayPl = 0.0;
$lDiv = 0.0;

foreach ($dashboard_rows as $row) {
    $totAmt += (float)$row['amount'];
    $totVal += (float)$row['value'];
    $totPl += (float)$row['pl'];
    $totTodayPl += (float)$row['today_pl'];
    $totDiv += (float)$row['dividends'];

    $change = (float)$row['change'];
    if ($change > 0) {
        $gAmt += (float)$row['amount'];
        $gVal += (float)$row['value'];
        $gPl += (float)$row['pl'];
        $gTodayPl += (float)$row['today_pl'];
        $gDiv += (float)$row['dividends'];
    } elseif ($change < 0) {
        $lAmt += (float)$row['amount'];
        $lVal += (float)$row['value'];
        $lPl += (float)$row['pl'];
        $lTodayPl += (float)$row['today_pl'];
        $lDiv += (float)$row['dividends'];
    }
}

$labels = array_map(static fn($row) => $row['scrip'], $dashboard_rows);
$profits = array_map(static fn($row) => $row['pl'], $dashboard_rows);
$values = array_map(static fn($row) => $row['current_value'], $dashboard_rows);
?>

<h3 class="mb-4">Dashboard View (Filtered by Portfolio)</h3>

<form method="GET" action="/market/dashboard2">
  <div class="row mb-3">
    <div class="col-md-4">
      <label for="portfolio_id" class="form-label">Select Portfolio</label>
      <select name="portfolio_id" class="form-select" id="portfolio_id" onchange="this.form.submit()">
        <?php foreach ($portfolios as $p): ?>
          <option value="<?= e($p['id']) ?>" <?= ($p['id'] == $selected_id) ? 'selected' : '' ?>><?= e($p['name']) ?></option>
        <?php endforeach; ?>
      </select>
    </div>
  </div>
</form>

<div class="btn-group mb-3" role="group" aria-label="Filter Gainers/Losers">
  <button type="button" class="btn btn-outline-success" onclick="filterTable('gainers')">Gainers</button>
  <button type="button" class="btn btn-outline-danger" onclick="filterTable('losers')">Losers</button>
  <button type="button" class="btn btn-outline-secondary" onclick="filterTable('all')">All</button>
</div>

<div class="mb-2">
  <button id="btn-zero" class="btn btn-sm btn-outline-secondary">Toggle qty = 0</button>
  <button id="btn-one" class="btn btn-sm btn-outline-secondary">Toggle qty = 1</button>
</div>

<table id="portfolioTable" class="table table-bordered table-striped table-hover">
  <thead class="table-dark">
    <tr>
      <th>Sr. No</th>
      <th>Scrip</th>
      <th>QTY</th>
      <th>Cost</th>
      <th>Amount</th>
      <th>Last Close</th>
      <th>Yesterday</th>
      <th>Today</th>
      <th>Change</th>
      <th>Change %</th>
      <th>Today P&L</th>
      <th>Txn</th>
      <th>Action</th>
      <th class="d-none">Sector</th>
      <th class="d-none">Current Value</th>
      <th class="d-none">Profit & Loss</th>
      <th class="d-none">Dividends</th>
      <th class="d-none">Total P&L</th>
      <th class="d-none">Value</th>
      <th class="d-none">P&L %</th>
      <th class="d-none">P&L, D %</th>
      <th class="d-none">Inv%</th>
      <th class="d-none">Portfolio</th>
      <th class="d-none">Dividend</th>
      <th class="d-none">Div ROI</th>
      <th class="d-none">Ideal Div</th>
    </tr>
  </thead>

  <tbody>
    <?php foreach ($dashboard_rows as $row): ?>
      <?php
        $card = [
            'sector' => $row['sector'],
            'Current Value' => $row['current_value'],
            'P&L' => $row['pl'],
            'Dividends' => $row['dividends'],
            'Total P&L' => $row['total_pl'],
            'Value' => $row['value'],
            'P&L %' => $row['pl_pct'],
            'P&L, D %' => $row['pl_d_pct'],
            'Inv %' => $row['inv_pct'],
            'Portfolio' => $row['portfolio'],
            'Dividend' => $row['dividend'],
            'Div ROI' => $row['div_roi'],
            'Ideal Div' => $row['ideal_div'],
        ];
      ?>
      <tr data-qty="<?= e($row['qty']) ?>"
          data-change="<?= e($row['change']) ?>"
          class="<?= ((int)$row['qty'] === 0) ? 'd-none' : '' ?> <?= ($row['pl'] > 0) ? 'table-success' : (($row['pl'] < 0) ? 'table-danger' : '') ?>"
          data-card='<?= e(json_encode($card)) ?>'>
        <td><?= e($row['sr']) ?></td>
        <td class="scrip-cell text-primary" style="cursor:pointer;">
          <?= e($row['scrip']) ?>
        </td>
        <td><?= e($row['qty']) ?></td>
        <td><?= e($row['cost']) ?></td>
        <td><?= e($row['amount']) ?></td>
        <td><?= e($row['last_close']) ?></td>
        <td><?= e($row['yesterday']) ?></td>
        <td><?= e($row['today']) ?></td>
        <td><?= e($row['change']) ?></td>
        <td><?= e($row['change_pct']) ?></td>
        <td class="<?= ($row['today_pl'] > 0) ? 'text-success' : (($row['today_pl'] < 0) ? 'text-danger' : '') ?>">
          <?= e($row['today_pl']) ?>
        </td>
        <td class="text-primary">
          <span class="txn-buy me-1" style="cursor:pointer;" title="Latest buys" data-txn='<?= e(json_encode($row['buy_txns'])) ?>'>BUY</span>
          <span class="txn-sell" style="cursor:pointer;" title="Latest sells" data-txn='<?= e(json_encode($row['sell_txns'])) ?>'>SELL</span>
        </td>
        <td>
          <span class="call-d me-1" style="cursor:pointer;" data-card='<?= e(json_encode($row['daily_call'])) ?>'>D</span>
          <span class="call-p" style="cursor:pointer;" data-card='<?= e(json_encode($row['pivot_call'])) ?>'>P</span>
        </td>
        <td class="d-none"><?= e($row['sector']) ?></td>
        <td class="d-none"><?= e($row['current_value']) ?></td>
        <td class="d-none"><?= e($row['pl']) ?></td>
        <td class="d-none"><?= e($row['dividends']) ?></td>
        <td class="d-none"><?= e($row['total_pl']) ?></td>
        <td class="d-none"><?= e($row['value']) ?></td>
        <td class="d-none"><?= e($row['pl_pct']) ?></td>
        <td class="d-none"><?= e($row['pl_d_pct']) ?></td>
        <td class="d-none"><?= e($row['inv_pct']) ?></td>
        <td class="d-none"><?= e($row['portfolio']) ?></td>
        <td class="d-none"><?= e($row['dividend']) ?></td>
        <td class="d-none"><?= e($row['div_roi']) ?></td>
        <td class="d-none"><?= e($row['ideal_div']) ?></td>
      </tr>
    <?php endforeach; ?>
  </tbody>
</table>

<h4 class="mt-4">Portfolio Summary</h4>
<table class="table table-bordered table-sm w-75 mb-4">
  <thead class="table-light">
    <tr>
      <th>Total Invested Amount</th>
      <th>Total Current Value</th>
      <th>Total Today P&L</th>
      <th>Total Profit/Loss</th>
      <th>Total Dividends</th>
      <th>Total P&L + Dividends</th>
      <th>Total P&L %</th>
    </tr>
  </thead>
  <tbody>
    <tr class="<?= ($totPl > 0) ? 'table-success' : (($totPl < 0) ? 'table-danger' : '') ?>">
      <td><?= number_format($totAmt, 2) ?></td>
      <td><?= number_format($totVal, 2) ?></td>
      <td class="<?= ($totTodayPl > 0) ? 'text-success' : (($totTodayPl < 0) ? 'text-danger' : '') ?>"><?= number_format($totTodayPl, 2) ?></td>
      <td class="<?= ($totPl > 0) ? 'text-success' : (($totPl < 0) ? 'text-danger' : '') ?>"><?= number_format($totPl, 2) ?></td>
      <td><?= number_format($totDiv, 2) ?></td>
      <td class="<?= (($totPl + $totDiv) > 0) ? 'text-success' : ((($totPl + $totDiv) < 0) ? 'text-danger' : '') ?>"><?= number_format($totPl + $totDiv, 2) ?></td>
      <td><?= $totAmt > 0 ? number_format(($totPl / $totAmt) * 100, 2) . '%' : '--' ?></td>
    </tr>
  </tbody>
</table>

<div class="row mb-4">
  <div class="col-md-6">
    <h5 class="text-success">Gainers Summary</h5>
    <table class="table table-bordered table-sm">
      <tbody>
        <tr><th>Invested Amount</th><td><?= number_format($gAmt, 2) ?></td></tr>
        <tr><th>Current Value</th><td><?= number_format($gVal, 2) ?></td></tr>
        <tr><th>Today P&L</th><td><?= number_format($gTodayPl, 2) ?></td></tr>
        <tr class="table-success"><th>Profit / Loss</th><td><?= number_format($gPl, 2) ?></td></tr>
        <tr><th>Dividends</th><td><?= number_format($gDiv, 2) ?></td></tr>
        <tr class="table-success"><th>Total P&L + Div</th><td><?= number_format($gPl + $gDiv, 2) ?></td></tr>
        <tr><th>P&L %</th><td><?= $gAmt > 0 ? number_format(($gPl / $gAmt) * 100, 2) . '%' : '--' ?></td></tr>
      </tbody>
    </table>
  </div>
  <div class="col-md-6">
    <h5 class="text-danger">Losers Summary</h5>
    <table class="table table-bordered table-sm">
      <tbody>
        <tr><th>Invested Amount</th><td><?= number_format($lAmt, 2) ?></td></tr>
        <tr><th>Current Value</th><td><?= number_format($lVal, 2) ?></td></tr>
        <tr><th>Today P&L</th><td><?= number_format($lTodayPl, 2) ?></td></tr>
        <tr class="table-danger"><th>Profit / Loss</th><td><?= number_format($lPl, 2) ?></td></tr>
        <tr><th>Dividends</th><td><?= number_format($lDiv, 2) ?></td></tr>
        <tr class="table-danger"><th>Total P&L + Div</th><td><?= number_format($lPl + $lDiv, 2) ?></td></tr>
        <tr><th>P&L %</th><td><?= $lAmt > 0 ? number_format(($lPl / $lAmt) * 100, 2) . '%' : '--' ?></td></tr>
      </tbody>
    </table>
  </div>
</div>

<div class="row mt-4">
  <div class="col-md-6">
    <canvas id="pnlPieChart"></canvas>
  </div>
  <div class="col-md-6">
    <canvas id="valueBarChart"></canvas>
  </div>
</div>

<link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/dataTables.bootstrap5.min.css">
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/dataTables.bootstrap5.min.js"></script>
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/buttons/2.0.1/css/buttons.dataTables.min.css"/>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/2.0.1/js/dataTables.buttons.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.html5.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
  $(document).ready(function () {
    $('#portfolioTable').DataTable({
        "pageLength": 50,
        "order": [[0, "asc"]],
        "dom": 'Bfrtip',
        "buttons": [
            {
                extend: 'excel',
                text: 'Export to Excel',
                className: 'btn-excel',
                title: 'Portfolio Data'
            }
        ]
    });
  });

  function filterTable(type) {
    $('#portfolioTable tbody tr').each(function () {
      const change = parseFloat($(this).data('change'));
      if (type === 'gainers' && change <= 0) {
        $(this).hide();
      } else if (type === 'losers' && change >= 0) {
        $(this).hide();
      } else {
        $(this).show();
      }
    });
  }

  const labels = <?= json_encode($labels, JSON_UNESCAPED_SLASHES) ?>;
  const profits = <?= json_encode($profits, JSON_UNESCAPED_SLASHES) ?>;
  const values = <?= json_encode($values, JSON_UNESCAPED_SLASHES) ?>;

  new Chart(document.getElementById('pnlPieChart'), {
    type: 'pie',
    data: {
      labels: labels,
      datasets: [{
        label: 'Profit & Loss',
        data: profits
      }]
    }
  });

  new Chart(document.getElementById('valueBarChart'), {
    type: 'bar',
    data: {
      labels: labels,
      datasets: [{
        label: 'Current Value',
        data: values
      }]
    }
  });
</script>

<script>
(function(){
  function toggle(q){
    document.querySelectorAll('#portfolioTable tbody tr[data-qty="'+q+'"]')
            .forEach(r=>r.classList.toggle('d-none'));
  }
  document.getElementById('btn-zero')?.addEventListener('click', () => toggle('0'));
  document.getElementById('btn-one')?.addEventListener('click', () => toggle('1'));

  let card = document.createElement('div');
  card.className = 'card shadow p-2 position-absolute small d-none';
  card.style.zIndex = 2000;
  document.body.appendChild(card);

  function pop(el, htmlMaker){
    const data = JSON.parse(el.dataset[Object.keys(el.dataset)[0]] || '{}');
    if(!Object.keys(data).length){ el.style.opacity = .3; return; }
    el.addEventListener('mouseenter',e=>{
      card.innerHTML = htmlMaker(data);
      card.style.left = (e.pageX+15)+'px';
      card.style.top = (e.pageY+15)+'px';
      card.classList.remove('d-none');
    });
    el.addEventListener('mousemove',e=>{
      card.style.left = (e.pageX+15)+'px';
      card.style.top = (e.pageY+15)+'px';
    });
    el.addEventListener('mouseleave',()=>card.classList.add('d-none'));
  }

  function txnHtml(list, side){
    return list.map(t=>`<div><strong>${t.d}</strong> ${side}@${t.p} (${t.q})</div>`).join('');
  }
  document.querySelectorAll('.txn-buy').forEach(el=>pop(el,d=>txnHtml(d,'BUY')));
  document.querySelectorAll('.txn-sell').forEach(el=>pop(el,d=>txnHtml(d,'SELL')));

  function dictHtml(obj){
    return Object.entries(obj).map(([k,v])=>`<div><strong>${k}:</strong> ${v}</div>`).join('');
  }
  document.querySelectorAll('.call-d').forEach(el=>pop(el,dictHtml));
  document.querySelectorAll('.call-p').forEach(el=>pop(el,dictHtml));
})();
</script>

<style>
.card.small{font-size:.78rem;min-width:220px;pointer-events:none;}
.call-d,.call-p{font-weight:600;}
</style>
