<?php
$title = 'Edit Dividend';
?>
<h2>Edit Dividend</h2>
<form method="post" class="card card-body">
  <div class="mb-3">
    <label class="form-label">Financial Year</label>
    <input name="financial_year" class="form-control" required value="<?= e($div['financial_year']) ?>">
  </div>

  <div class="mb-3">
    <label class="form-label">Net Dividend (PKR)</label>
    <input name="net_amount" type="number" step="0.01" min="0" class="form-control" required value="<?= e($div['net_amount']) ?>">
  </div>

  <div class="mb-3">
    <label class="form-label">Payment Date</label>
    <input name="payment_date" type="text" class="form-control" placeholder="dd/mm/yyyy" required value="<?= e(date('d/m/Y', strtotime((string)$div['payment_date']))) ?>">
  </div>

  <button class="btn btn-success">Save</button>
  <a href="/dividends?portfolio_id=<?= e($div['portfolio_id']) ?>" class="btn btn-outline-secondary ms-2">Cancel</a>
</form>
