<?php
$title = 'Dividends';
?>
<h2>Dividends</h2>
<h5>dividends/?portfolio_id=<?= e($portfolio_id) ?></h5>
<form action="/dividends/import" method="post" enctype="multipart/form-data" class="d-flex gap-2 mb-3">
  <input type="hidden" name="portfolio_id" value="<?= e($portfolio_id) ?>">
  <input type="file" name="file" accept=".csv" required class="form-control">
  <button class="btn btn-primary">Import CSV</button>
  <a class="btn btn-outline-secondary" href="/dividends?portfolio_id=<?= e($portfolio_id) ?>&export=1">Export CSV</a>
  <a class="btn btn-success" href="/dividends/new?portfolio_id=<?= e($portfolio_id) ?>">Add Dividend</a>
</form>

<table class="table table-sm table-striped align-middle">
  <thead class="table-light">
    <tr>
      <th>Symbol</th>
      <th>Year</th>
      <th class="text-end">Net (PKR)</th>
      <th>Paid On</th>
      <th style="width:9rem"></th>
    </tr>
  </thead>
  <tbody>
    <?php foreach ($dividends as $d): ?>
      <tr>
        <td><?= e($d['symbol'] ?? '') ?></td>
        <td><?= e($d['financial_year'] ?? '') ?></td>
        <td class="text-end"><?= number_format((float)($d['net_amount'] ?? 0), 2) ?></td>
        <td><?= e(date('d/m/Y', strtotime((string)($d['payment_date'] ?? '')))) ?></td>
        <td>
          <a class="btn btn-sm btn-outline-secondary me-1" href="/dividends/<?= e($d['id']) ?>/edit">Edit</a>
          <form action="/dividends/<?= e($d['id']) ?>/delete" method="post" class="d-inline" onsubmit="return confirm('Delete dividend?');">
            <button class="btn btn-sm btn-outline-danger">Delete</button>
          </form>
        </td>
      </tr>
    <?php endforeach; ?>
  </tbody>
</table>
