<?php
$title = 'Add Dividend';
?>
<h2>Add Dividend</h2>
<form method="post" class="card card-body">
  <input type="hidden" name="portfolio_id" value="<?= e($portfolio_id) ?>">

  <div class="mb-3">
    <label class="form-label">Security Symbol</label>
    <input name="symbol" class="form-control" required placeholder="e.g. TGL">
  </div>

  <div class="mb-3">
    <label class="form-label">Financial Year</label>
    <input name="financial_year" class="form-control" required placeholder="2024-25">
  </div>

  <div class="mb-3">
    <label class="form-label">Net Dividend (PKR)</label>
    <input name="net_amount" type="number" step="0.01" min="0" class="form-control" required>
  </div>

  <div class="mb-3">
    <label class="form-label">Payment Date</label>
    <input name="payment_date" type="text" class="form-control" placeholder="dd/mm/yyyy" required>
  </div>

  <button class="btn btn-success">Save</button>
  <a href="/dividends?portfolio_id=<?= e($portfolio_id) ?>" class="btn btn-outline-secondary ms-2">Cancel</a>
</form>
