<?php
$title = 'Edit Holding';
?>
<h3>Edit Holding</h3>

<form method="POST" action="/portfolio/edit/<?= e($holding['id']) ?>" class="row g-3 mb-4">
  <input type="hidden" name="portfolio_id" value="<?= e($holding['portfolio_id']) ?>">

  <div class="col-md-4">
    <select name="symbol" class="form-select" required>
      <option value="" disabled>Select Stock</option>
      <?php foreach ($stocks as $s): ?>
        <option value="<?= e($s['symbol']) ?>" <?= ($s['symbol'] === $holding['symbol']) ? 'selected' : '' ?>>
          <?= e($s['symbol']) ?> - <?= e($s['sector']) ?>
        </option>
      <?php endforeach; ?>
    </select>
  </div>

  <div class="col-md-2">
    <input type="number" name="qty" class="form-control" value="<?= e($holding['quantity']) ?>" required>
  </div>

  <div class="col-md-2">
    <input type="number" step="0.01" name="price" class="form-control" value="<?= e($holding['buy_price']) ?>" required>
  </div>

  <div class="col-md-2">
    <button type="submit" class="btn btn-success w-100">Update</button>
  </div>
</form>

<a href="/portfolio?portfolio_id=<?= e($holding['portfolio_id']) ?>" class="btn btn-secondary">Cancel</a>
