<?php
$title = 'Edit Transaction';
?>
<h3>Edit Transaction</h3>

<form method="POST" action="/transaction/edit/<?= e($tx['id']) ?>" class="row g-3 mb-4">
  <div class="col-md-2">
    <select name="portfolio_id" class="form-select" required>
      <?php foreach ($portfolios as $portfolio): ?>
        <option value="<?= e($portfolio['id']) ?>" <?= ($portfolio['id'] == $tx['portfolio_id']) ? 'selected' : '' ?>><?= e($portfolio['name']) ?></option>
      <?php endforeach; ?>
    </select>
  </div>

  <div class="col-md-2">
    <select name="symbol" class="form-select" required>
      <?php foreach ($stocks as $s): ?>
        <option value="<?= e($s['symbol']) ?>" <?= ($s['id'] == $tx['stock_id']) ? 'selected' : '' ?>>
          <?= e($s['symbol']) ?> - <?= e($s['sector']) ?>
        </option>
      <?php endforeach; ?>
    </select>
  </div>

  <div class="col-md-2">
    <select name="type" class="form-select">
      <option value="buy" <?= ($tx['type'] === 'buy') ? 'selected' : '' ?>>Buy</option>
      <option value="sell" <?= ($tx['type'] === 'sell') ? 'selected' : '' ?>>Sell</option>
    </select>
  </div>

  <div class="col-md-2">
    <input type="number" name="qty" value="<?= e($tx['quantity']) ?>" class="form-control" required>
  </div>

  <div class="col-md-2">
    <input type="number" step="0.01" name="price" value="<?= e($tx['price']) ?>" class="form-control" required>
  </div>

  <div class="col-md-2">
    <button type="submit" class="btn btn-success w-100">Update</button>
  </div>
</form>

<a href="/transaction?portfolio_id=<?= e($tx['portfolio_id']) ?>" class="btn btn-secondary">Cancel</a>
