<?php
$title = $title ?? 'PSX Portfolio';
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title><?= e($title) ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
  <style>
    body { background-color: #f8f9fa; }
    .navbar-brand { font-weight: bold; letter-spacing: 1px; }
    .table th, .table td { vertical-align: middle; }
    .dashboard-header { display: flex; justify-content: space-between; align-items: center; }
    .dashboard-header h3 { margin-bottom: 0; }
    .table-container { overflow-x: auto; }
  </style>
</head>
<body>
<nav class="navbar navbar-expand-lg navbar-dark bg-dark">
  <div class="container-fluid">
    <a class="navbar-brand" href="/">PSX Tracker</a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
      <span class="navbar-toggler-icon"></span>
    </button>
    <div class="collapse navbar-collapse" id="navbarNav">
      <ul class="navbar-nav me-auto mb-2 mb-lg-0">
        <li class="nav-item"><a class="nav-link" href="/market/dashboard2">Dashboard</a></li>
        <li class="nav-item"><a class="nav-link" href="/portfolio">Portfolio</a></li>
        <li class="nav-item"><a class="nav-link" href="/transaction">Transactions</a></li>
        <li class="nav-item"><a class="nav-link" href="/stocks">Stocks</a></li>
        <li class="nav-item"><a class="nav-link" href="/dividends?portfolio_id=1">Dividends</a></li>
        <li class="nav-item"><a class="nav-link" href="/js-calls">JS Calls</a></li>
      </ul>
    </div>
  </div>
</nav>
<div class="container mt-4">
  <?php foreach (flashes() as $flash): ?>
    <div class="alert alert-<?= e($flash['type']) ?>">
      <?= e($flash['message']) ?>
    </div>
  <?php endforeach; ?>
  <?= $content ?>
</div>
</body>
</html>
