<?php
$title = 'Portfolio';
?>
<h3>My Portfolio Holdings</h3>

<form method="GET" action="/portfolio">
  <div class="row mb-4">
    <div class="col-md-6">
      <select name="portfolio_id" class="form-select" onchange="this.form.submit()">
        <?php foreach ($portfolios as $p): ?>
          <option value="<?= e($p['id']) ?>" <?= ($p['id'] == $selected_id) ? 'selected' : '' ?>><?= e($p['name']) ?></option>
        <?php endforeach; ?>
      </select>
    </div>
  </div>
</form>

<form method="POST" action="/portfolio/add" class="row g-3 mb-4">
  <input type="hidden" name="portfolio_id" value="<?= e($selected_id) ?>">
  <div class="col-md-4">
    <select name="symbol" class="form-select" required>
      <option value="" disabled selected>Select Symbol</option>
      <?php foreach ($stocks as $s): ?>
        <option value="<?= e($s['symbol']) ?>"><?= e($s['symbol']) ?> - <?= e($s['sector']) ?></option>
      <?php endforeach; ?>
    </select>
  </div>
  <div class="col-md-2"><input type="number" name="qty" class="form-control" placeholder="Quantity" required></div>
  <div class="col-md-2"><input type="number" step="0.01" name="price" class="form-control" placeholder="Buy Price" required></div>
  <div class="col-md-2"><button type="submit" class="btn btn-primary w-100">Add</button></div>
</form>

<form method="POST" action="/portfolio/import" enctype="multipart/form-data" class="row g-3 mb-4">
  <input type="hidden" name="portfolio_id" value="<?= e($selected_id) ?>">
  <div class="col-md-6">
    <input type="file" name="file" class="form-control" required>
  </div>
  <div class="col-md-2">
    <button type="submit" class="btn btn-outline-success">Import</button>
  </div>
</form>

<table class="table table-striped">
  <thead>
    <tr>
      <th>Symbol</th>
      <th>Sector</th>
      <th>Quantity</th>
      <th>Buy Price</th>
      <th>Actions</th>
    </tr>
  </thead>
  <tbody>
    <?php foreach ($holdings as $h): ?>
      <tr>
        <td><?= e($h['symbol']) ?></td>
        <td><?= e($h['sector']) ?></td>
        <td><?= e($h['quantity']) ?></td>
        <td><?= number_format((float)$h['buy_price'], 2) ?></td>
        <td>
          <a href="/portfolio/edit/<?= e($h['id']) ?>" class="btn btn-sm btn-warning">Edit</a>
          <a href="/portfolio/delete/<?= e($h['id']) ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this holding?');">Delete</a>
        </td>
      </tr>
    <?php endforeach; ?>
  </tbody>
</table>
