<?php
$title = 'Stock Management';
?>
<h3>Stock List</h3>

<form action="/stocks/add" method="post" class="row g-3 mb-4">
  <div class="col-md-3"><input type="text" name="symbol" class="form-control" placeholder="Symbol" required></div>
  <div class="col-md-4"><input type="text" name="sector" class="form-control" placeholder="Sector" required></div>
  <div class="col-md-2"><button type="submit" class="btn btn-primary w-100">Add Stock</button></div>
</form>

<form action="/stocks/upload-json" method="post" enctype="multipart/form-data" class="row g-3 mb-4">
  <div class="col-md-5"><input type="file" name="file" accept=".json" class="form-control" required></div>
  <div class="col-md-2"><button type="submit" class="btn btn-secondary w-100">Upload JSON</button></div>
</form>

<table class="table table-bordered">
  <thead><tr><th>Symbol</th><th>Sector</th><th>Actions</th></tr></thead>
  <tbody>
    <?php foreach ($stocks as $s): ?>
      <tr>
        <td><?= e($s['symbol']) ?></td>
        <td><?= e($s['sector']) ?></td>
        <td><a href="/stocks/delete/<?= e($s['id']) ?>" class="btn btn-sm btn-danger">Delete</a></td>
      </tr>
    <?php endforeach; ?>
  </tbody>
</table>
