<?php
$title = 'Transactions';

$buyCost = 0.0;
$sellGross = 0.0;
$sellFees = 0.0;
$sellCgt = 0.0;
$realizedPl = 0.0;
$currentCost = 0.0;

foreach ($transactions as $tx) {
    $gross = (float)($tx['gross_amount'] ?? 0);
    $comm = (float)($tx['commission'] ?? 0);
    $sst = (float)($tx['sst'] ?? 0);
    $fees = $comm + $sst;
    $cgt = (float)($tx['cgt'] ?? 0);

    if ($tx['type'] === 'buy') {
        $buyCost += $gross + $fees;
    } elseif ($tx['type'] === 'sell') {
        $sellGross += $gross;
        $sellFees += $fees;
        $sellCgt += $cgt;
        $realizedPl += (float)($tx['realized_pl'] ?? 0);
    }
}

foreach ($holdings as $h) {
    if ((int)$h['quantity'] > 0) {
        $currentCost += (int)$h['quantity'] * (float)$h['buy_price'];
    }
}

$wallet = 0.0;
$contributed = 0.0;

$chron = $transactions;
usort($chron, static function ($a, $b) {
    return strtotime((string)$a['date']) <=> strtotime((string)$b['date']);
});

foreach ($chron as $tx) {
    $gross = (float)($tx['gross_amount'] ?? ($tx['quantity'] * $tx['price']));
    $comm = (float)($tx['commission'] ?? 0);
    $sst = (float)($tx['sst'] ?? 0);
    $cgt = (float)($tx['cgt'] ?? 0);

    if ($tx['type'] === 'buy') {
        $cost = $gross + $comm + $sst;
        if ($cost > $wallet) {
            $contributed += ($cost - $wallet);
            $wallet = 0.0;
        } else {
            $wallet -= $cost;
        }
    } elseif ($tx['type'] === 'sell') {
        $netIn = $gross - $comm - $sst - $cgt;
        $wallet += $netIn;
    }
}

$dividendsSum = 0.0;
foreach ($dividends as $d) {
    $dividendsSum += (float)($d['net_amount'] ?? 0);
}

$totalProfit = $dividendsSum + $realizedPl;
?>

<h3>Record Transaction</h3>

<form method="POST" action="/transaction/add" class="row g-3 mb-4">
  <div class="col-md-2">
    <label for="portfolio_id_add" class="form-label">Portfolio</label>
    <select name="portfolio_id" id="portfolio_id_add" class="form-select" required>
      <option value="" disabled selected>Select Portfolio</option>
      <?php foreach ($portfolios as $portfolio): ?>
        <option value="<?= e($portfolio['id']) ?>" <?= ($selected_portfolio_id && $portfolio['id'] == $selected_portfolio_id) ? 'selected' : '' ?>><?= e($portfolio['name']) ?></option>
      <?php endforeach; ?>
    </select>
  </div>

  <div class="col-md-2">
    <label for="symbol" class="form-label">Symbol</label>
    <select name="symbol" id="symbol" class="form-select" required>
      <option value="" disabled selected>Select Symbol</option>
      <?php foreach ($stocks as $s): ?>
        <option value="<?= e($s['symbol']) ?>"><?= e($s['symbol']) ?> - <?= e($s['sector']) ?></option>
      <?php endforeach; ?>
    </select>
  </div>

  <div class="col-md-2">
    <label for="type" class="form-label">Type</label>
    <select name="type" id="type" class="form-select" required>
      <option value="buy">Buy</option>
      <option value="sell">Sell</option>
    </select>
  </div>

  <div class="col-md-2">
    <label for="qty" class="form-label">Quantity</label>
    <input type="number" name="qty" id="qty" class="form-control" placeholder="Qty" required>
  </div>

  <div class="col-md-2">
    <label for="price" class="form-label">Price</label>
    <input type="number" step="0.01" name="price" id="price" class="form-control" placeholder="Price" required>
  </div>

  <div class="col-md-2">
    <label class="form-label d-block">&nbsp;</label>
    <button type="submit" class="btn btn-success w-100">Record</button>
  </div>
</form>

<hr class="my-4">

<h4>Upload Sales CSV</h4>
<form method="POST" action="/transaction/upload-sales-excel" enctype="multipart/form-data" class="row g-3 mb-4">
  <div class="col-md-3">
    <label for="portfolio_id_sales" class="form-label">Portfolio</label>
    <select name="portfolio_id" id="portfolio_id_sales" class="form-select" required>
      <option value="" disabled selected>Select Portfolio</option>
      <?php foreach ($portfolios as $portfolio): ?>
        <option value="<?= e($portfolio['id']) ?>" <?= ($selected_portfolio_id && $portfolio['id'] == $selected_portfolio_id) ? 'selected' : '' ?>><?= e($portfolio['name']) ?></option>
      <?php endforeach; ?>
    </select>
  </div>

  <div class="col-md-5">
    <label for="file_sales" class="form-label">Select Sales CSV</label>
    <input type="file" name="file" id="file_sales" accept=".csv" class="form-control" required>
  </div>

  <div class="col-md-2">
    <label class="form-label d-block">&nbsp;</label>
    <button type="submit" class="btn btn-secondary w-100">Upload CSV</button>
  </div>
</form>

<h4>Upload Purchase CSV</h4>
<form method="POST" action="/transaction/upload-purchase-excel" enctype="multipart/form-data" class="row g-3 mb-4">
  <div class="col-md-3">
    <label for="portfolio_id_purchase" class="form-label">Portfolio</label>
    <select name="portfolio_id" id="portfolio_id_purchase" class="form-select" required>
      <option value="" disabled selected>Select Portfolio</option>
      <?php foreach ($portfolios as $portfolio): ?>
        <option value="<?= e($portfolio['id']) ?>" <?= ($selected_portfolio_id && $portfolio['id'] == $selected_portfolio_id) ? 'selected' : '' ?>><?= e($portfolio['name']) ?></option>
      <?php endforeach; ?>
    </select>
  </div>

  <div class="col-md-5">
    <label for="file_purchase" class="form-label">Select Purchase CSV</label>
    <input type="file" name="file" id="file_purchase" accept=".csv" class="form-control" required>
  </div>

  <div class="col-md-2">
    <label class="form-label d-block">&nbsp;</label>
    <button type="submit" class="btn btn-secondary w-100">Upload Purchase</button>
  </div>
</form>

<h4>Upload Transaction CSV</h4>
<form method="POST" action="/transaction/upload-transaction-excel" enctype="multipart/form-data" class="row g-3 mb-4">
  <div class="col-md-3">
    <label for="portfolio_id_txn" class="form-label">Portfolio</label>
    <select name="portfolio_id" id="portfolio_id_txn" class="form-select" required>
      <option value="" disabled selected>Select Portfolio</option>
      <?php foreach ($portfolios as $portfolio): ?>
        <option value="<?= e($portfolio['id']) ?>" <?= ($selected_portfolio_id && $portfolio['id'] == $selected_portfolio_id) ? 'selected' : '' ?>><?= e($portfolio['name']) ?></option>
      <?php endforeach; ?>
    </select>
  </div>

  <div class="col-md-4">
    <label for="txn_excel" class="form-label">Upload CSV File</label>
    <input type="file" name="file" class="form-control" id="txn_excel" accept=".csv" required>
  </div>

  <div class="col-md-2 d-flex align-items-end">
    <button type="submit" class="btn btn-primary w-100">Upload</button>
  </div>
</form>

<?php if (!empty($portfolios)): ?>
  <form method="GET" class="mb-3">
    <label for="portfolio_id_filter" class="form-label">View transactions for portfolio:</label>
    <select name="portfolio_id" id="portfolio_id_filter" class="form-select w-auto d-inline-block">
      <?php foreach ($portfolios as $portfolio): ?>
        <option value="<?= e($portfolio['id']) ?>" <?= ($selected_portfolio_id && $portfolio['id'] == $selected_portfolio_id) ? 'selected' : '' ?>><?= e($portfolio['name']) ?></option>
      <?php endforeach; ?>
    </select>
    <button type="submit" class="btn btn-primary">View</button>
  </form>
<?php endif; ?>

<h5>Past Transactions</h5>

<div class="row mb-4">
  <div class="col-md-2">
    <div class="card text-bg-light">
      <div class="card-body">
        <h5>cash contributed so far</h5><br>
        <?= number_format($contributed, 2) ?><br>
        <strong>Current holdings cost (gross):</strong><br>
        <?= number_format($currentCost, 2) ?><br>
      </div>
    </div>
  </div>
  <div class="col-md-2">
    <div class="card text-bg-light">
      <div class="card-body">
        <strong>Bought cost (incl. fees):</strong><br>
        <?= number_format($buyCost, 2) ?><br>
        <strong>Sold gross:</strong><br>
        <?= number_format($sellGross, 2) ?>
      </div>
    </div>
  </div>
  <div class="col-md-2">
    <div class="card text-bg-light">
      <div class="card-body">
        <strong>Sell CGT:</strong><br>
        <?= number_format($sellCgt, 2) ?>
      </div>
    </div>
  </div>
  <div class="col-md-2">
    <div class="card text-bg-light">
      <div class="card-body">
        <strong>Total Sells fees:</strong><br>
        <?= number_format($sellFees, 2) ?>
      </div>
    </div>
  </div>
  <div class="col-md-2">
    <div class="card text-bg-light">
      <div class="card-body">
        <strong>Realized Profit:</strong><br>
        <span class="<?= $realizedPl > 0 ? 'text-success' : ($realizedPl < 0 ? 'text-danger' : '') ?>">
          <strong><?= number_format($realizedPl, 2) ?></strong>
        </span>
      </div>
    </div>
  </div>
  <div class="col-md-2">
    <div class="card text-bg-light">
      <div class="card-body">
        <strong>Total Dividends</strong><br>
        <?= number_format($dividendsSum, 2) ?><br>
        <strong>Total profit</strong><br>
        <?= number_format($totalProfit, 2) ?>
      </div>
    </div>
  </div>
</div>

<div class="row">
<table class="table">
  <thead class="table-dark">
    <tr>
      <th>Date</th>
      <th>Symbol</th>
      <th>Type</th>
      <th>Qty</th>
      <th>Unit Price</th>
      <th>Gross</th>
      <th>Commission</th>
      <th>SST</th>
      <th>CGT</th>
      <th>Net Amount</th>
      <th>realized pl</th>
      <th>Actions</th>
    </tr>
  </thead>
  <tbody>
    <?php foreach ($transactions as $tx): ?>
      <tr>
        <td><?= e(date('Y-m-d H:i', strtotime((string)$tx['date']))) ?></td>
        <td><?= e($tx['symbol']) ?></td>
        <td><?= e($tx['type']) ?></td>
        <td><?= e($tx['quantity']) ?></td>
        <td><?= number_format((float)$tx['price'], 2) ?></td>
        <td><?= number_format((float)($tx['gross_amount'] ?? 0), 2) ?></td>
        <td><?= number_format((float)($tx['commission'] ?? 0), 2) ?></td>
        <td><?= number_format((float)($tx['sst'] ?? 0), 2) ?></td>
        <td><?= number_format((float)($tx['cgt'] ?? 0), 2) ?></td>
        <td><?= number_format((float)($tx['net_amount'] ?? ($tx['quantity'] * $tx['price'])), 2) ?></td>
        <td><?= number_format((float)($tx['realized_pl'] ?? 0), 2) ?></td>
        <td>
          <a href="/transaction/edit/<?= e($tx['id']) ?>" class="btn btn-sm btn-warning">Edit</a>
          <a href="/transaction/delete/<?= e($tx['id']) ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this transaction?');">Delete</a>
        </td>
      </tr>
    <?php endforeach; ?>
  </tbody>
</table>
</div>

<?php if (!empty($holdings)): ?>
<h5>Current Holdings</h5>

<div class="mb-2">
  <button id="btn-zero" class="btn btn-sm btn-outline-secondary">Toggle qty = 0</button>
  <button id="btn-one" class="btn btn-sm btn-outline-secondary">Toggle qty = 1</button>
</div>

<table class="table table-bordered" id="holdings-table">
  <thead>
    <tr>
      <th>Symbol</th>
      <th>Sector</th>
      <th>Quantity</th>
      <th>Avg. Buy Price</th>
    </tr>
  </thead>
  <tbody>
    <?php foreach ($holdings as $h): ?>
      <tr data-qty="<?= e($h['quantity']) ?>" class="<?= ((int)$h['quantity'] === 0) ? 'd-none' : '' ?>">
        <td><?= e($h['symbol']) ?></td>
        <td><?= e($h['sector'] ?: '--') ?></td>
        <td><?= e($h['quantity']) ?></td>
        <td><?= number_format((float)$h['buy_price'], 2) ?></td>
      </tr>
    <?php endforeach; ?>
  </tbody>
</table>
<?php endif; ?>

<link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/dataTables.bootstrap5.min.css">
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/dataTables.bootstrap5.min.js"></script>
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/buttons/2.0.1/css/buttons.dataTables.min.css"/>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/2.0.1/js/dataTables.buttons.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.html5.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>

<script>
  $(document).ready(function () {
    $('.table').DataTable({
        "pageLength": 50,
        "order": [[0, "asc"]],
        "dom": 'Bfrtip',
        "buttons": [
            {
                extend: 'excel',
                text: 'Export to Excel',
                className: 'btn-excel',
                title: 'Portfolio Data'
            }
        ]
    });
  });
</script>
<script>
(function () {
  function toggleRows(targetQty) {
    document
      .querySelectorAll(`#holdings-table tbody tr[data-qty="${targetQty}"]`)
      .forEach(row => row.classList.toggle('d-none'));
  }

  document.getElementById('btn-zero')?.addEventListener('click', () => toggleRows('0'));
  document.getElementById('btn-one')?.addEventListener('click', () => toggleRows('1'));
})();
</script>
