<?php

declare(strict_types=1);

require __DIR__ . '/../app/bootstrap.php';

use App\Router;
use App\Controllers\DashboardController;
use App\Controllers\PortfolioController;
use App\Controllers\TransactionsController;
use App\Controllers\MarketController;
use App\Controllers\StocksController;
use App\Controllers\JsCallsController;
use App\Controllers\DividendsController;

$router = new Router();

$router->get('/', [DashboardController::class, 'index']);
$router->post('/', [DashboardController::class, 'index']);

$router->get('/portfolio', [PortfolioController::class, 'index']);
$router->post('/portfolio/add', [PortfolioController::class, 'add']);
$router->get('/portfolio/delete/{id}', [PortfolioController::class, 'delete']);
$router->get('/portfolio/edit/{id}', [PortfolioController::class, 'edit']);
$router->post('/portfolio/edit/{id}', [PortfolioController::class, 'edit']);
$router->post('/portfolio/import', [PortfolioController::class, 'import']);

$router->get('/transaction', [TransactionsController::class, 'index']);
$router->post('/transaction/add', [TransactionsController::class, 'add']);
$router->get('/transaction/delete/{id}', [TransactionsController::class, 'delete']);
$router->get('/transaction/edit/{id}', [TransactionsController::class, 'edit']);
$router->post('/transaction/edit/{id}', [TransactionsController::class, 'edit']);
$router->post('/transaction/upload-sales-excel', [TransactionsController::class, 'uploadSalesExcel']);
$router->post('/transaction/upload-purchase-excel', [TransactionsController::class, 'uploadPurchaseExcel']);
$router->post('/transaction/upload-transaction-excel', [TransactionsController::class, 'uploadTransactionExcel']);

$router->get('/market', [MarketController::class, 'index']);
$router->get('/market/dashboard2', [MarketController::class, 'dashboard2']);

$router->get('/stocks', [StocksController::class, 'index']);
$router->post('/stocks/add', [StocksController::class, 'add']);
$router->post('/stocks/upload-json', [StocksController::class, 'uploadJson']);
$router->get('/stocks/delete/{id}', [StocksController::class, 'delete']);

$router->get('/js-calls', [JsCallsController::class, 'dashboard']);
$router->get('/js-calls/upload-daily', [JsCallsController::class, 'uploadDaily']);
$router->post('/js-calls/upload-daily', [JsCallsController::class, 'uploadDaily']);
$router->get('/js-calls/daily-calls', [JsCallsController::class, 'listDaily']);
$router->get('/js-calls/edit-daily/{id}', [JsCallsController::class, 'editDaily']);
$router->post('/js-calls/edit-daily/{id}', [JsCallsController::class, 'editDaily']);
$router->get('/js-calls/delete-daily/{id}', [JsCallsController::class, 'deleteDaily']);

$router->get('/js-calls/upload-pivot', [JsCallsController::class, 'uploadPivot']);
$router->post('/js-calls/upload-pivot', [JsCallsController::class, 'uploadPivot']);
$router->get('/js-calls/pivot-calls', [JsCallsController::class, 'listPivot']);
$router->get('/js-calls/edit-pivot/{id}', [JsCallsController::class, 'editPivot']);
$router->post('/js-calls/edit-pivot/{id}', [JsCallsController::class, 'editPivot']);
$router->get('/js-calls/delete-pivot/{id}', [JsCallsController::class, 'deletePivot']);

$router->get('/dividends', [DividendsController::class, 'index']);
$router->post('/dividends/import', [DividendsController::class, 'import']);
$router->get('/dividends/new', [DividendsController::class, 'create']);
$router->post('/dividends/new', [DividendsController::class, 'create']);
$router->get('/dividends/{id}/edit', [DividendsController::class, 'edit']);
$router->post('/dividends/{id}/edit', [DividendsController::class, 'edit']);
$router->post('/dividends/{id}/delete', [DividendsController::class, 'delete']);

$path = parse_url($_SERVER['REQUEST_URI'] ?? '/', PHP_URL_PATH) ?? '/';
$router->dispatch($_SERVER['REQUEST_METHOD'] ?? 'GET', $path);
